## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "html40.tcl"
 #                                    created: 97-12-20 15.02.44 
 #                                last update: 99-04-24 13.19.24 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4
 # 
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##
proc html40.tcl {} {}

#
# htmlElemAttrRequired: the per-element lists of all required attributes
# htmlElemAttrOptional: the per-element lists of all optional attributes
# htmlElemAttrChoices: element-specific attribute completions
# htmlElemAttrNumber: the per-element list of attributes which are numbers.
# htmlElemEventHandler: the per-element list of JavaScript's event handlers.
# htmlElemAttrUsed: the per-element list of elements asked for in the status bar.
# htmlElemExtension: Extension to HTML 4.
# htmlDeprecated: Deprecated in HTML 4.
#
# htmlElemAttrOptional has to be defined for every element for everything
# to work.

# A
set htmlElemAttrOptional1(A)	{HREF= HREFLANG= NAME= TARGET= CHARSET= TYPE= SHAPE= COORDS=
ACCESSKEY= TABINDEX= REL= REV= }
set htmlElemAttrChoices1(A) {SHAPE=RECT SHAPE=CIRCLE SHAPE=POLY SHAPE=DEFAULT}
set htmlElemAttrNumber1(A) {TABINDEX=1:32767:n}
set htmlElemEventHandler1(A)	{onFocus= onBlur=}
ensureset htmlElemAttrUsed(A) {HREF= NAME= TARGET=}

# ABBR
set htmlElemAttrOptional1(ABBR) {}

# ACRONYM
set htmlElemAttrOptional1(ACRONYM) {}

# ADDRESS
set htmlElemAttrOptional1(ADDRESS) {}

# APPLET
set htmlElemAttrRequired1(APPLET)	{WIDTH= HEIGHT=}
set htmlElemAttrOptional1(APPLET) 	{CODE= CODEBASE= ARCHIVE= OBJECT= HSPACE= VSPACE= ALIGN= NAME= ALT=
MAYSCRIPT}
set htmlElemAttrChoices1(APPLET)	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT}
set htmlElemAttrNumber1(APPLET) 	{VSPACE=0:i:n HSPACE=0:i:n WIDTH=1:i:%
HEIGHT=1:i:%}
ensureset htmlElemAttrUsed(APPLET)	{WIDTH= HEIGHT= CODE= CODEBASE= ALIGN= }
set htmlElemExtension(APPLET) {MAYSCRIPT}

# AREA
set htmlElemAttrRequired1(AREA) {ALT=}
set htmlElemAttrOptional1(AREA)	{SHAPE= COORDS= TARGET= HREF= NOHREF ACCESSKEY= TABINDEX=}
set htmlElemAttrChoices1(AREA)	{SHAPE=RECT SHAPE=CIRCLE SHAPE=POLY
SHAPE=DEFAULT}
set htmlElemAttrNumber1(AREA) {TABINDEX=1:32767:n}
set htmlElemEventHandler1(AREA)	{onFocus= onBlur=}
ensureset htmlElemAttrUsed(AREA)	{ALT= SHAPE= COORDS= TARGET= HREF= NOHREF}

# B
set htmlElemAttrOptional1(B) {}

# BASE
set htmlElemAttrOptional1(BASE)	{HREF= TARGET=}
ensureset htmlElemAttrUsed(BASE)	{HREF= TARGET=}

# BASEFONT
set htmlElemAttrRequired1(BASEFONT)	{SIZE=}
set htmlElemAttrOptional1(BASEFONT) {COLOR= FACE= ID=}
set htmlElemAttrNumber1(BASEFONT)	{SIZE=1:7:n}
ensureset htmlElemAttrUsed(BASEFONT) {SIZE= COLOR= FACE=}

# BDO
set htmlElemAttrRequired1(BDO) {DIR=}
set htmlElemAttrOptional1(BDO) {LANG=}
set htmlElemAttrChoices1(BDO) {DIR=LTR DIR=RTL}
ensureset htmlElemAttrUsed(BDO) {DIR= LANG=}

# BIG
set htmlElemAttrOptional1(BIG) {}

# BLOCKQUOTE
set htmlElemAttrOptional1(BLOCKQUOTE) {CITE=}

# BODY
set htmlElemAttrOptional1(BODY)	{BACKGROUND= BGPROPERTIES= BGCOLOR= TEXT= LINK= VLINK= ALINK=
LEFTMARGIN= TOPMARGIN=}
set htmlElemAttrChoices1(BODY) {BGPROPERTIES=FIXED}
set htmlElemAttrNumber1(BODY) {LEFTMARGIN=0:i:n TOPMARGIN=0:i:n}
set htmlElemEventHandler1(BODY)	{onLoad= onUnload=}
set htmlElemExtension(BODY) {BGPROPERTIES= LEFTMARGIN= TOPMARGIN=}
set htmlElemDeprecated(BODY) {BACKGROUND= BGCOLOR= TEXT= LINK= VLINK= ALINK=}
ensureset htmlElemAttrUsed(BODY) {BACKGROUND= BGCOLOR= TEXT= LINK= VLINK=}

# BR
set htmlElemAttrOptional1(BR)	{CLEAR=}
set htmlElemAttrChoices1(BR)	{CLEAR=ALL CLEAR=LEFT CLEAR=RIGHT CLEAR=NONE}
set htmlElemDeprecated(BR) {CLEAR=}
ensureset htmlElemAttrUsed(BR) {CLEAR=}

# BUTTON
set htmlElemAttrOptional1(BUTTON) {NAME= VALUE= TYPE= DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrChoices1(BUTTON) {TYPE=BUTTON TYPE=RESET TYPE=SUBMIT}
set htmlElemAttrNumber1(BUTTON) {TABINDEX=0:32767:n}
set htmlElemEventHandler1(BUTTON) {onFocus= onBlur=}
ensureset htmlElemAttrUsed(BUTTON) {NAME= VALUE= TYPE= DISABLED}

# CAPTION
set htmlElemAttrOptional1(CAPTION)	{ALIGN=}
set htmlElemAttrChoices1(CAPTION)	{ALIGN=BOTTOM ALIGN=TOP ALIGN=LEFT ALIGN=RIGHT}
set htmlElemDeprecated(CAPTION) {ALIGN=}
ensureset htmlElemAttrUsed(CAPTION) {ALIGN=}

# CENTER
set htmlElemAttrOptional1(CENTER) {}

# CITE
set htmlElemAttrOptional1(CITE) {}

# CODE
set htmlElemAttrOptional1(CODE) {}

# COL
set htmlElemAttrOptional1(COL)	{SPAN= ALIGN= VALIGN= WIDTH= CHAR= CHAROFF=}
set htmlElemAttrNumber1(COL)	{SPAN=1:i:n CHAROFF=0:i:%}
set htmlElemAttrChoices1(COL) {ALIGN=LEFT ALIGN=CENTER ALIGN=RIGHT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP}
ensureset htmlElemAttrUsed(COL) {SPAN= ALIGN= VALIGN= WIDTH=}

# COLGROUP
set htmlElemAttrOptional1(COLGROUP)	{SPAN= ALIGN= VALIGN= WIDTH= CHAR= CHAROFF=}
set htmlElemAttrNumber1(COLGROUP)	{SPAN=1:i:n CHAROFF=0:i:%}
set htmlElemAttrChoices1(COLGROUP) {ALIGN=LEFT ALIGN=CENTER ALIGN=RIGHT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP}
ensureset htmlElemAttrUsed(COLGROUP) {SPAN= ALIGN= VALIGN= WIDTH=}

# DD
set htmlElemAttrOptional1(DD)	{}

# DEL
set htmlElemAttrOptional1(DEL) {CITE= DATETIME=}
ensureset htmlElemAttrUsed(DEL) {CITE= DATETIME=}

# DFN
set htmlElemAttrOptional1(DFN) {}

# DIR
set htmlElemAttrOptional1(DIR) {COMPACT}

# DIV
set htmlElemAttrOptional1(DIV)	{ALIGN=}
set htmlElemAttrChoices1(DIV)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(DIV) {ALIGN=}
ensureset htmlElemAttrUsed(DIV) {ALIGN=}

# DL
set htmlElemAttrOptional1(DL) {COMPACT}
set htmlElemDeprecated(DL) {COMPACT}

# DT
set htmlElemAttrOptional1(DT) {}

# EM
set htmlElemAttrOptional1(EM) {}

# FIELDSET
set htmlElemAttrOptional1(FIELDSET) {}

# FONT
set htmlElemAttrOptional1(FONT)	{SIZE= COLOR= FACE= POINT-SIZE=}
set htmlElemAttrNumber1(FONT)	{SIZE=1:7:n POINT-SIZE=1:i:n}
set htmlElemExtension(FONT) {POINT-SIZE=}
ensureset htmlElemAttrUsed(FONT)	{SIZE= COLOR= FACE=}

# FORM
set htmlElemAttrRequired1(FORM) {ACTION=}
set htmlElemAttrOptional1(FORM)	{METHOD= ENCTYPE= TARGET= ACCEPT-CHARSET= ACCEPT= NAME=}
set htmlElemAttrChoices1(FORM)	{METHOD=POST METHOD=GET}
set htmlElemEventHandler1(FORM)	{onReset= onSubmit=}
set htmlElemExtension(FORM) {NAME=}
ensureset htmlElemAttrUsed(FORM) {ACTION= METHOD= }

# FRAME
set htmlElemAttrOptional1(FRAME)	{SRC= NAME= MARGINWIDTH= MARGINHEIGHT= SCROLLING=
NORESIZE FRAMEBORDER= LONGDESC= BORDERCOLOR=}
set htmlElemAttrChoices1(FRAME)	{SCROLLING=YES SCROLLING=NO SCROLLING=AUTO 
FRAMEBORDER=1 FRAMEBORDER=0}
set htmlElemAttrNumber1(FRAME)	{MARGINWIDTH=0:i:n MARGINHEIGHT=0:i:n}
set htmlElemExtension(FRAME) {BORDERCOLOR=}
ensureset htmlElemAttrUsed(FRAME)	{SRC= NAME= MARGINWIDTH= MARGINHEIGHT= SCROLLING=
NORESIZE FRAMEBORDER=}

# FRAMESET
set htmlElemAttrOptional1(FRAMESET) {ROWS= COLS= FRAMEBORDER= BORDER= BORDERCOLOR= FRAMESPACING=}
set htmlElemAttrNumber1(FRAMESET)	{BORDER=0:i:n FRAMESPACING=0:i:n}
set htmlElemAttrChoices1(FRAMESET)	{FRAMEBORDER=1 FRAMEBORDER=0}
set htmlElemEventHandler1(FRAMESET)	{onLoad= onUnload=}
set htmlElemExtension(FRAMESET) {FRAMEBORDER= BORDER= BORDERCOLOR= FRAMESPACING=}
ensureset htmlElemAttrUsed(FRAMESET) {ROWS= COLS=}

# H1
set htmlElemAttrOptional1(H1)	{ALIGN= }
set htmlElemAttrChoices1(H1)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(H1)		{ALIGN=}
ensureset htmlElemAttrUsed(H1)	{ALIGN=}

# H2
set htmlElemAttrOptional1(H2)	{ALIGN= }
set htmlElemAttrChoices1(H2)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(H2)		{ALIGN=}
ensureset htmlElemAttrUsed(H2)	{ALIGN=}

# H3
set htmlElemAttrOptional1(H3)	{ALIGN= }
set htmlElemAttrChoices1(H3)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(H3)		{ALIGN=}
ensureset htmlElemAttrUsed(H3)	{ALIGN=}

# H4
set htmlElemAttrOptional1(H4)	{ALIGN= }
set htmlElemAttrChoices1(H4)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(H4)		{ALIGN=}
ensureset htmlElemAttrUsed(H4)	{ALIGN=}

# H5
set htmlElemAttrOptional1(H5)	{ALIGN= }
set htmlElemAttrChoices1(H5)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(H5)		{ALIGN=}
ensureset htmlElemAttrUsed(H5)	{ALIGN=}

# H6
set htmlElemAttrOptional1(H6)	{ALIGN= }
set htmlElemAttrChoices1(H6)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(H6)		{ALIGN=}
ensureset htmlElemAttrUsed(H6)	{ALIGN=}

# HEAD
set htmlElemAttrOptional1(HEAD) {PROFILE=}

# HR
set htmlElemAttrOptional1(HR)	{ALIGN= SIZE= WIDTH= COLOR= NOSHADE}
set htmlElemAttrChoices1(HR)	{ALIGN=LEFT ALIGN=RIGHT ALIGN=CENTER}
set htmlElemAttrNumber1(HR) 	{SIZE=1:i:n WIDTH=1:i:%}
set htmlElemExtension(HR)	{COLOR=}
set htmlElemDeprecated(HR)	{ALIGN= SIZE= WIDTH= NOSHADE}

# HTML
set htmlElemAttrOptional1(HTML) {}

# I
set htmlElemAttrOptional1(I) {}

# IFRAME
set htmlElemAttrOptional1(IFRAME) {SRC= NAME= WIDTH= HEIGHT= MARGINWIDTH= MARGINHEIGHT= SCROLLING=
ALIGN= FRAMEBORDER= LONGDESC=}
set htmlElemAttrNumber1(IFRAME)	{WIDTH=1:i:% HEIGHT=1:i:% MARGINWIDTH=1:i:n MARGINHEIGHT=1:i:n}
set htmlElemAttrChoices1(IFRAME) {SCROLLING=YES SCROLLING=NO SCROLLING=AUTO ALIGN=TOP 
ALIGN=MIDDLE ALIGN=BOTTOM ALIGN=LEFT ALIGN=RIGHT FRAMEBORDER=1 FRAMEBORDER=0}
set htmlElemDeprecated(IFRAME)	{ALIGN=}
ensureset htmlElemAttrUsed(IFRAME) {SRC= NAME= WIDTH= HEIGHT= MARGINWIDTH= MARGINHEIGHT= SCROLLING= ALIGN=}

# IMG
set htmlElemAttrRequired1(IMG)	{SRC= ALT=}
set htmlElemAttrOptional1(IMG)	{LOWSRC= WIDTH= HEIGHT=  BORDER= 
ALIGN= HSPACE= VSPACE= USEMAP= ISMAP LONGDESC= DYNSRC= LOOP= START= CONTROLS}
set htmlElemAttrChoices1(IMG)	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT START=FILEOPEN START=MOUSEOVER}
set htmlElemAttrNumber1(IMG) {BORDER=0:i:% WIDTH=1:i:% HEIGHT=1:i:%
HSPACE=0:i:n VSPACE=0:i:n LOOP=-1:i:n}
set htmlElemEventHandler1(IMG)	{onAbort= onError= onLoad=}
set htmlElemExtension(IMG) {LOWSRC= CONTROLS DYNSRC= LOOP= START= onAbort= onError= onLoad=}
set htmlElemDeprecated(IMG) {ALIGN= BORDER= HSPACE= VSPACE=}
ensureset htmlElemAttrUsed(IMG)	{SRC= ALT= WIDTH= HEIGHT= BORDER= ALIGN= HSPACE= VSPACE=}

# INPUT=TEXT
set htmlElemAttrOptional1([list INPUT TYPE=TEXT])	{NAME= VALUE= SIZE= MAXLENGTH= DISABLED READONLY ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=TEXT])	{SIZE=1:i:n MAXLENGTH=1:i:n TABINDEX=0:32767:n}
set htmlElemEventHandler1([list INPUT TYPE=TEXT])	{onFocus= onBlur= onChange= onSelect=}
ensureset htmlElemAttrUsed([list INPUT TYPE=TEXT])	{NAME= VALUE= SIZE= MAXLENGTH=}

# INPUT=CHECKBOX
set htmlElemAttrRequired1([list INPUT TYPE=CHECKBOX])	{VALUE=}
set htmlElemAttrOptional1([list INPUT TYPE=CHECKBOX])	{NAME= CHECKED DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=CHECKBOX]) {TABINDEX=0:32767:n}
ensureset htmlElemAttrUsed([list INPUT TYPE=CHECKBOX])	{NAME= VALUE= CHECKED}

# INPUT=BUTTON
set htmlElemAttrOptional1([list INPUT TYPE=BUTTON])	{NAME= VALUE= DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=BUTTON]) {TABINDEX=0:32767:n}
ensureset htmlElemAttrUsed([list INPUT TYPE=BUTTON])	{NAME= VALUE=}

# INPUT=RADIO
set htmlElemAttrRequired1([list INPUT TYPE=RADIO])	{VALUE=}
set htmlElemAttrOptional1([list INPUT TYPE=RADIO])	{NAME= CHECKED DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=RADIO]) {TABINDEX=0:32767:n}
ensureset htmlElemAttrUsed([list INPUT TYPE=RADIO])	{NAME= VALUE= CHECKED}

# INPUT=SUBMIT
set htmlElemAttrOptional1([list INPUT TYPE=SUBMIT])	{NAME= VALUE= DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=SUBMIT]) {TABINDEX=0:32767:n}
ensureset htmlElemAttrUsed([list INPUT TYPE=SUBMIT])	{NAME= VALUE=}

# INPUT=RESET
set htmlElemAttrOptional1([list INPUT TYPE=RESET])	{VALUE= DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=RESET]) {TABINDEX=0:32767:n}
ensureset htmlElemAttrUsed([list INPUT TYPE=RESET])	{VALUE=}

# INPUT=PASSWORD
set htmlElemAttrOptional1([list INPUT TYPE=PASSWORD])	{NAME= VALUE= SIZE= MAXLENGTH= DISABLED READONLY ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=PASSWORD])	{SIZE=1:i:n MAXLENGTH=1:i:n TABINDEX=0:32767:n}
set htmlElemEventHandler1([list INPUT TYPE=PASSWORD])	{onFocus= onBlur= onChange= onSelect=}
ensureset htmlElemAttrUsed([list INPUT TYPE=PASSWORD])	{NAME= VALUE= SIZE= MAXLENGTH=}

# INPUT=HIDDEN
set htmlElemAttrOptional1([list INPUT TYPE=HIDDEN])	{NAME= VALUE=}
ensureset htmlElemAttrUsed([list INPUT TYPE=HIDDEN])	{NAME= VALUE=}

# INPUT=IMAGE
set htmlElemAttrRequired1([list INPUT TYPE=IMAGE])	{SRC=}
set htmlElemAttrOptional1([list INPUT TYPE=IMAGE])	{NAME= ALIGN= ALT= USEMAP= DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrChoices1([list INPUT TYPE=IMAGE])	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT}
set htmlElemAttrNumber1([list INPUT TYPE=IMAGE]) {TABINDEX=0:32767:n}
set htmlElemDeprecated([list INPUT TYPE=IMAGE]) {ALIGN=}
ensureset htmlElemAttrUsed([list INPUT TYPE=IMAGE])	{SRC= NAME= ALT=}

# INPUT=FILE
set htmlElemAttrOptional1([list INPUT TYPE=FILE])	{NAME= SIZE= MAXLENGTH= ACCEPT= DISABLED ACCESSKEY= TABINDEX=}
set htmlElemAttrNumber1([list INPUT TYPE=FILE])	{SIZE=1:i:n MAXLENGTH=1:i:n TABINDEX=0:32767:n}
ensureset htmlElemAttrUsed([list INPUT TYPE=FILE]) {NAME= SIZE= MAXLENGTH=}

# INS
set htmlElemAttrOptional1(INS) {CITE= DATETIME=}
ensureset htmlElemAttrUsed(INS) {CITE= DATETIME=}

# ISINDEX
set htmlElemAttrOptional1(ISINDEX)	{ACTION= PROMPT=}
set htmlElemExtension(ISINDEX) {ACTION=}

# KBD
set htmlElemAttrOptional1(KBD) {}

# LABEL
set htmlElemAttrOptional1(LABEL) {FOR= ACCESSKEY=}
set htmlElemEventHandler1(LABEL) {onFocus= onBlur=}
ensureset htmlElemAttrUsed(LABEL) {FOR= ACCESSKEY=}

# LEGEND
set htmlElemAttrOptional1(LEGEND) {ALIGN= ACCESSKEY=}
set htmlElemAttrChoices1(LEGEND) {ALIGN=TOP ALIGN=BOTTOM ALIGN=LEFT ALIGN=RIGHT}
set htmlElemDeprecated(LEGEND) {ALIGN=}
ensureset htmlElemAttrUsed(LEGEND) {ALIGN= ACCESSKEY=}

# LI
set htmlElemAttrOptional1([list LI IN UL])	{TYPE=}
set htmlElemAttrChoices1([list LI IN UL])	{TYPE=DISC TYPE=CIRCLE TYPE=SQUARE}
set htmlElemDeprecated([list LI IN UL])		{TYPE=}
ensureset htmlElemAttrUsed([list LI IN UL]) {TYPE=}
set htmlElemAttrOptional1([list LI IN OL])	{TYPE= VALUE=}
set htmlElemAttrNumber1([list LI IN OL])	{VALUE=1:i:n}
set htmlElemAttrChoices1([list LI IN OL])	{TYPE=A TYPE=a TYPE=I TYPE=i TYPE=1}
set htmlElemDeprecated([list LI IN OL])		{TYPE= VALUE=}
ensureset htmlElemAttrUsed([list LI IN OL]) {TYPE= VALUE=}
set htmlElemAttrOptional1(LI) {}

# LINK
set htmlElemAttrOptional1(LINK)	{HREF= HREFLANG= TARGET= CHARSET= REL= REV= TYPE= MEDIA=}
ensureset htmlElemAttrUsed(LINK) {HREF= REL= TYPE=}

# MAP
set htmlElemAttrRequired1(MAP)		{NAME=}
set htmlElemAttrOptional1(MAP)		{}

# MENU
set htmlElemAttrOptional1(MENU) {COMPACT}

# META
set htmlElemAttrRequired1(META)	{CONTENT=}
set htmlElemAttrOptional1(META)	{NAME= HTTP-EQUIV= SCHEME=}
ensureset htmlElemAttrUsed(META) {CONTENT= NAME= HTTP-EQUIV=}

# NOFRAMES
set htmlElemAttrOptional1(NOFRAMES) {}

# NOSCRIPT
set htmlElemAttrOptional1(NOSCRIPT) {}

# OBJECT
set htmlElemAttrOptional1(OBJECT) {CLASSID= CODEBASE= CODETYPE= ARCHIVE= DATA= NAME= TYPE= STANDBY=
ALIGN= BORDER= WIDTH= HEIGHT= HSPACE= VSPACE= USEMAP= DECLARE TABINDEX=}
set htmlElemAttrNumber1(OBJECT) {WIDTH=1:i:% HEIGHT=1:i:% HSPACE=0:i:n VSPACE=0:i:n BORDER=0:i:%
TABINDEX=0:32767:n}
set htmlElemAttrChoices1(OBJECT) {ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT}
set htmlElemDeprecated(OBJECT) {ALIGN= BORDER= HSPACE= VSPACE=}
ensureset htmlElemAttrUsed(OBJECT) {CLASSID= CODETYPE= ARCHIVE= DATA= NAME= TYPE= WIDTH= HEIGHT= STANDBY=}

# OL
set htmlElemAttrOptional1(OL)	{TYPE= START= COMPACT}
set htmlElemAttrChoices1(OL)	{TYPE=A TYPE=a TYPE=I TYPE=i TYPE=1}
set htmlElemAttrNumber1(OL)	{START=1:i:n}
set htmlElemDeprecated(OL)	{TYPE= START= COMPACT}
ensureset htmlElemAttrUsed(OL) {TYPE= START=}

# OPTGROUP
set htmlElemAttrRequired1(OPTGROUP) {LABEL=}
set htmlElemAttrOptional1(OPTGROUP) {DISABLED}
ensureset htmlElemAttrUsed(OPTGROUP) {LABEL= DISABLED}

# OPTION
set htmlElemAttrOptional1(OPTION)	{VALUE= LABEL= SELECTED DISABLED}
ensureset htmlElemAttrUsed(OPTION)	{VALUE= SELECTED}

# P
set htmlElemAttrOptional1(P)	{ALIGN= }
set htmlElemAttrChoices1(P)		{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY}
set htmlElemDeprecated(P)		{ALIGN=}
ensureset htmlElemAttrUsed(P)	{ALIGN=}

# PARAM
set htmlElemAttrRequired1(PARAM)	{NAME=}
set htmlElemAttrOptional1(PARAM)	{VALUE= TYPE= VALUETYPE= ID=}
set htmlElemAttrChoices1(PARAM) {VALUETYPE=REF VALUETYPE=OBJECT VALUETYPE=DATA}
ensureset htmlElemAttrUsed(PARAM) {NAME= VALUE=}

# PRE
set htmlElemAttrOptional1(PRE)	{WIDTH=}
set htmlElemDeprecated(PRE)	{WIDTH=}
set htmlElemAttrNumber1(PRE) 	{WIDTH=1:i:n}

# Q
set htmlElemAttrOptional1(Q) {CITE=}

# S
set htmlElemAttrOptional1(S) {}

# SAMP
set htmlElemAttrOptional1(SAMP) {}

# SCRIPT
set htmlElemAttrRequired1(SCRIPT) {TYPE=}
set htmlElemAttrOptional1(SCRIPT)	{LANGUAGE= SRC= ARCHIVE= DEFER CHARSET=}
set htmlElemExtension(SCRIPT) {ARCHIVE=}
set htmlElemDeprecated(SCRIPT)	{LANGUAGE=}
ensureset htmlElemAttrUsed(SCRIPT)	{TYPE= LANGUAGE= SRC=}

# SELECT
set htmlElemAttrOptional1(SELECT)	{NAME= SIZE= TABINDEX= MULTIPLE DISABLED}
set htmlElemAttrNumber1(SELECT)	{SIZE=1:i:n TABINDEX=0:32767:n}
set htmlElemEventHandler1(SELECT)	{onFocus= onBlur= onChange=}
ensureset htmlElemAttrUsed(SELECT)	{NAME= SIZE= MULTIPLE}

# SMALL
set htmlElemAttrOptional1(SMALL) {}

# SPAN
set htmlElemAttrOptional1(SPAN) {}

# STRIKE
set htmlElemAttrOptional1(STRIKE) {}

# STRONG
set htmlElemAttrOptional1(STRONG) {}

# STYLE
set htmlElemAttrRequired1(STYLE) {TYPE=}
set htmlElemAttrOptional1(STYLE) {MEDIA= TITLE=}
ensureset htmlElemAttrUsed(STYLE) {TYPE=}

# SUB
set htmlElemAttrOptional1(SUB) {}

# SUP
set htmlElemAttrOptional1(SUP) {}

# TABLE
set htmlElemAttrOptional1(TABLE)	{BORDER= CELLSPACING= CELLPADDING= COLS= WIDTH= HEIGHT=
ALIGN= FRAME= RULES= SUMMARY= BGCOLOR= BORDERCOLOR= BORDERCOLORDARK= BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemAttrChoices1(TABLE)	{ALIGN=LEFT ALIGN=CENTER ALIGN=RIGHT FRAME=BORDER
FRAME=VOID FRAME=ABOVE FRAME=BELOW FRAME=HSIDES FRAME=VSIDES FRAME=LHS FRAME=RHS FRAME=BOX
RULES=GROUPS RULES=ROWS RULES=COLS RULES=ALL RULES=NONE}
set htmlElemAttrNumber1(TABLE)	{BORDER=0:i:n CELLSPACING=0:i:% COLS=1:i:n
CELLPADDING=0:i:% WIDTH=1:i:% HEIGHT=1:i:%}
set htmlElemExtension(TABLE) {COLS= HEIGHT= BORDERCOLOR= BORDERCOLORDARK= BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemDeprecated(TABLE) {ALIGN= BGCOLOR=}
ensureset htmlElemAttrUsed(TABLE)	{BORDER= CELLSPACING= CELLPADDING=}

# TBODY
set htmlElemAttrOptional1(TBODY) {ALIGN= VALIGN= CHAR= CHAROFF=}
set htmlElemAttrNumber1(TBODY) {CHAROFF=0:i:%}
set htmlElemAttrChoices1(TBODY) {ALIGN=LEFT ALIGN=CENTER ALIGN=RIGHT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP}
ensureset htmlElemAttrUsed(TBODY) {ALIGN= VALIGN=}

# TEXTAREA
set htmlElemAttrRequired1(TEXTAREA)	{ROWS= COLS=}
set htmlElemAttrOptional1(TEXTAREA)	{NAME= WRAP= ACCESSKEY= TABINDEX= DISABLED READONLY}
set htmlElemAttrNumber1(TEXTAREA)	{ROWS=1:i:n COLS=1:i:n TABINDEX=0:32767:n}
set htmlElemAttrChoices1(TEXTAREA) {WRAP=VIRTUAL WRAP=PHYSICAL WRAP=OFF}
set htmlElemEventHandler1(TEXTAREA)	{onFocus= onBlur= onChange= onSelect=}
set htmlElemExtension(TEXTAREA) {WRAP=}
ensureset htmlElemAttrUsed(TEXTAREA) {ROWS= COLS= NAME=}

# TD
set htmlElemAttrOptional1(TD)	{ALIGN= VALIGN= CHAR= CHAROFF= COLSPAN= ROWSPAN= WIDTH= HEIGHT=
NOWRAP ABBR= AXIS= HEADERS= SCOPE= BGCOLOR= BORDERCOLOR= BORDERCOLORDARK= 
BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemAttrChoices1(TD)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP SCOPE=ROW SCOPE=COL SCOPE=ROWGROUP
SCOPE=COLGROUP}
set htmlElemAttrNumber1(TD)	{CHAROFF=0:i:% COLSPAN=0:i:n ROWSPAN=0:i:n WIDTH=1:i:n HEIGHT=1:i:n}
set htmlElemExtension(TD) {BORDERCOLOR= BORDERCOLORDARK= BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemDeprecated(TD) {NOWRAP BGCOLOR= WIDTH= HEIGHT=}
ensureset htmlElemAttrUsed(TD)	{ALIGN= VALIGN= COLSPAN= ROWSPAN= WIDTH= NOWRAP}

# TFOOT
set htmlElemAttrOptional1(TFOOT) {ALIGN= VALIGN= CHAR= CHAROFF=}
set htmlElemAttrNumber1(TFOOT) {CHAROFF=0:i:%}
set htmlElemAttrChoices1(TFOOT) {ALIGN=LEFT ALIGN=CENTER ALIGN=RIGHT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP}
ensureset htmlElemAttrUsed(TFOOT) {ALIGN= VALIGN=}

# TH
set htmlElemAttrOptional1(TH)	{ALIGN= VALIGN= CHAR= CHAROFF= COLSPAN= ROWSPAN= WIDTH= HEIGHT=
NOWRAP ABBR= AXIS= HEADERS= SCOPE= BGCOLOR= BORDERCOLOR= BORDERCOLORDARK= 
BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemAttrChoices1(TH)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP SCOPE=ROW SCOPE=COL SCOPE=ROWGROUP
SCOPE=COLGROUP}
set htmlElemAttrNumber1(TH)	{CHAROFF=0:i:% COLSPAN=0:i:n ROWSPAN=0:i:n WIDTH=1:i:n HEIGHT=1:i:n}
set htmlElemExtension(TH) {BORDERCOLOR= BORDERCOLORDARK= BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemDeprecated(TH) {NOWRAP BGCOLOR= WIDTH= HEIGHT=}
ensureset htmlElemAttrUsed(TH)	{ALIGN= VALIGN= COLSPAN= ROWSPAN= WIDTH= NOWRAP}

# THEAD
set htmlElemAttrOptional1(THEAD) {ALIGN= VALIGN= CHAR= CHAROFF=}
set htmlElemAttrNumber1(THEAD) {CHAROFF=0:i:%}
set htmlElemAttrChoices1(THEAD) {ALIGN=LEFT ALIGN=CENTER ALIGN=RIGHT ALIGN=JUSTIFY ALIGN=CHAR
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP}
ensureset htmlElemAttrUsed(THEAD) {ALIGN= VALIGN=}

# TITLE
set htmlElemAttrOptional1(TITLE) {}

# TR
set htmlElemAttrOptional1(TR)	{ALIGN= VALIGN= CHAR= CHAROFF= BGCOLOR= BORDERCOLOR= BORDERCOLORDARK=
BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemAttrChoices1(TR)	{ALIGN=CENTER ALIGN=RIGHT ALIGN=LEFT  
VALIGN=BASELINE VALIGN=BOTTOM VALIGN=MIDDLE VALIGN=TOP }
set htmlElemAttrNumber1(TR) {CHAROFF=0:i:%}
set htmlElemExtension(TR) {BORDERCOLOR= BORDERCOLORDARK= BORDERCOLORLIGHT= BACKGROUND=}
set htmlElemDeprecated(TR) {BGCOLOR=}
ensureset htmlElemAttrUsed(TR)	{ALIGN= VALIGN=}

# TT
set htmlElemAttrOptional1(TT) {}

# U
set htmlElemAttrOptional1(U) {}

# UL
set htmlElemAttrOptional1(UL)	{TYPE= COMPACT}
set htmlElemAttrChoices1(UL)	{TYPE=DISC TYPE=CIRCLE TYPE=SQUARE}
set htmlElemDeprecated(UL)	{TYPE= COMPACT}
ensureset htmlElemAttrUsed(UL) {TYPE=}

# VAR
set htmlElemAttrOptional1(VAR) {}

#===============================================================================
# Extensions
#===============================================================================

# BGSOUND
set htmlElemAttrRequired1(BGSOUND) {SRC=}
set htmlElemAttrOptional1(BGSOUND) {LOOP=}
set htmlElemAttrNumber1(BGSOUND) {LOOP=-1:i:n}
ensureset htmlElemAttrUsed(BGSOUND) {SRC= LOOP=}

# BLINK
set htmlElemAttrOptional1(BLINK) {}

# EMBED
set htmlElemAttrRequired1(EMBED)	{SRC= WIDTH= HEIGHT=}
set htmlElemAttrOptional1(EMBED)	{HSPACE= VSPACE= ALIGN=}
set htmlElemAttrNumber1(EMBED) {WIDTH=1:i:n HEIGHT=1:i:n HSPACE=1:i:n VSPACE=1:i:n}
set htmlElemAttrChoices1(EMBED)	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT}

set htmlElemAttrRequired1(LIVEAUDIO) {SRC= WIDTH= HEIGHT=}
set htmlElemAttrOptional1(LIVEAUDIO)	{HSPACE= VSPACE= ALIGN= AUTOSTART= LOOP=}
set htmlElemAttrNumber1(LIVEAUDIO) {WIDTH=1:i:n HEIGHT=1:i:n HSPACE=1:i:n VSPACE=1:i:n}
set htmlElemAttrChoices1(LIVEAUDIO)	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT
AUTOSTART=TRUE AUTOSTART=FALSE LOOP=TRUE LOOP=FALSE}
ensureset htmlElemAttrUsed(LIVEAUDIO) {SRC= WIDTH= HEIGHT= AUTOSTART= LOOP=}

set htmlElemAttrRequired1(LIVEVIDEO) {SRC= WIDTH= HEIGHT=}
set htmlElemAttrOptional1(LIVEVIDEO)	{HSPACE= VSPACE= ALIGN= AUTOSTART= LOOP= CONTROLS=}
set htmlElemAttrNumber1(LIVEVIDEO) {WIDTH=1:i:n HEIGHT=1:i:n HSPACE=1:i:n VSPACE=1:i:n}
set htmlElemAttrChoices1(LIVEVIDEO)	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT
AUTOSTART=TRUE AUTOSTART=FALSE LOOP=TRUE LOOP=FALSE CONTROLS=TRUE CONTROLS=FALSE}
ensureset htmlElemAttrUsed(LIVEVIDEO) {SRC= WIDTH= HEIGHT= AUTOSTART= LOOP= CONTROLS=}

set htmlElemAttrRequired1([list QUICKTIME MOVIE])	{SRC= }
set htmlElemAttrOptional1([list QUICKTIME MOVIE])	{WIDTH= HEIGHT= HSPACE= VSPACE= ALIGN=
HIDDEN= AUTOPLAY= CONTROLLER= LOOP= PLAYEVERYFRAME= HREF= TARGET= PLUGINSPAGE=}
set htmlElemAttrNumber1([list QUICKTIME MOVIE]) {WIDTH=1:i:n HEIGHT=1:i:n HSPACE=1:i:n VSPACE=1:i:n}
set htmlElemAttrChoices1([list QUICKTIME MOVIE])	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT HIDDEN=TRUE HIDDEN=FALSE
AUTOPLAY=TRUE AUTOPLAY=FALSE CONTROLLER=TRUE CONTROLLER=FALSE LOOP=TRUE LOOP=FALSE 
LOOP=PALINDROME PLAYEVERYFRAME=TRUE PLAYEVERYFRAME=FALSE}
ensureset htmlElemAttrUsed([list QUICKTIME MOVIE]) {SRC= WIDTH= HEIGHT= HIDDEN= AUTOPLAY= CONTROLLER= LOOP= 
PLAYEVERYFRAME=}

set htmlElemAttrRequired1([list QUICKTIME VR])	{SRC= WIDTH= HEIGHT=}
set htmlElemAttrOptional1([list QUICKTIME VR])	{HSPACE= VSPACE= ALIGN= PAN= TILT= FOV=
NODE= CORRECTION= PLUGINSPAGE=}
set htmlElemAttrNumber1([list QUICKTIME VR]) {WIDTH=1:i:n HEIGHT=1:i:n 
HSPACE=1:i:n VSPACE=1:i:n PAN=0:360:n TILT=-360:360:n FOV=-360:360:n NODE=0:i:n}
set htmlElemAttrChoices1([list QUICKTIME VR])	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT
CORRECTION=NONE CORRECTION=PARTIAL CORRECTION=FULL}
ensureset htmlElemAttrUsed([list QUICKTIME VR]) {SRC= WIDTH= HEIGHT= PAN= TILT= FOV=
NODE= CORRECTION=}

set htmlElemAttrRequired1(REALAUDIO)	{SRC= WIDTH= HEIGHT=}
set htmlElemAttrOptional1(REALAUDIO)	{HSPACE= VSPACE= ALIGN= CONTROLS= AUTOSTART=
NOLABELS= CONSOLE=}
set htmlElemAttrNumber1(REALAUDIO) {WIDTH=1:i:n HEIGHT=1:i:n HSPACE=1:i:n VSPACE=1:i:n}
set htmlElemAttrChoices1(REALAUDIO)	{ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM 
ALIGN=LEFT ALIGN=RIGHT
CONTROLS=ALL CONTROLS=CONTROLPANEL CONTROLS=INFOVOLUMEPANEL CONTROLS=INFOPANEL
CONTROLS=STATUSBAR CONTROLS=PLAYBUTTON CONTROLS=STOPBUTTON CONTROLS=VOLUMESLIDER
CONTROLS=POSITIONSLIDER CONTROLS=POSITIONFIELD CONTROLS=STATUSFIELD
AUTOSTART=TRUE AUTOSTART=FALSE NOLABELS=TRUE NOLABELS=FALSE}
ensureset htmlElemAttrUsed(REALAUDIO) {SRC= WIDTH= HEIGHT= CONTROLS= AUTOSTART=
NOLABELS= CONSOLE=}

# ILAYER
set htmlElemAttrOptional1(ILAYER) {LEFT= TOP= PAGEX= PAGEY= NAME= SRC= WIDTH= HEIGHT= CLIP= Z-INDEX=
ABOVE= BELOW= VISIBILITY= BGCOLOR= BACKGROUND=}
set htmlElemAttrChoices1(ILAYER) {VISIBILITY=SHOW VISIBILITY=HIDDEN VISIBILITY=INHERIT}
set htmlElemAttrNumber1(ILAYER) {LEFT=-i:i:n TOP=-i:i:n PAGEX=0:i:n PAGEY=0:i:n WIDTH=1:i:%
HEIGHT=1:i:% Z-INDEX=1:i:n}
set htmlElemEventHandler1(ILAYER) {onLoad=}
ensureset htmlElemAttrUsed(ILAYER) {LEFT= TOP= SRC= WIDTH= HEIGHT= VISIBILITY=}

# KEYGEN
set htmlElemAttrRequired1(KEYGEN) {NAME=}
set htmlElemAttrOptional1(KEYGEN) {CHALLENGE=}
ensureset htmlElemAttrUsed(KEYGEN) {NAME=}

# LAYER
set htmlElemAttrOptional1(LAYER) {LEFT= TOP= PAGEX= PAGEY= NAME= SRC= WIDTH= HEIGHT= CLIP= Z-INDEX=
ABOVE= BELOW= VISIBILITY= BGCOLOR= BACKGROUND=}
set htmlElemAttrChoices1(LAYER) {VISIBILITY=SHOW VISIBILITY=HIDDEN VISIBILITY=INHERIT}
set htmlElemAttrNumber1(LAYER) {LEFT=-i:i:n TOP=-i:i:n PAGEX=0:i:n PAGEY=0:i:n WIDTH=1:i:%
HEIGHT=1:i:% Z-INDEX=1:i:n}
set htmlElemEventHandler1(LAYER) {onLoad=}
ensureset htmlElemAttrUsed(LAYER) {LEFT= TOP= SRC= WIDTH= HEIGHT= VISIBILITY=}

# MARQUEE
set htmlElemAttrOptional1(MARQUEE) {BEHAVIOR= DIRECTION= ALIGN= LOOP= WIDTH= HEIGHT=
HSPACE= VSPACE= BGCOLOR= SCROLLAMOUNT= SCROLLDELAY=}
set htmlElemAttrNumber1(MARQUEE) {LOOP=-1:i:n HEIGHT=1:i:% WIDTH=1:i:% HSPACE=0:i:n
VSPACE=0:i:n SCROLLAMOUNT=1:i:n SCROLLDELAY=1:i:n}
set htmlElemAttrChoices1(MARQUEE) {BEHAVIOR=SLIDE BEHAVIOR=ALTERNATE BEHAVIOR=SCROLL
DIRECTION=RIGHT DIRECTION=LEFT ALIGN=TOP ALIGN=MIDDLE ALIGN=BOTTOM}
ensureset htmlElemAttrUsed(MARQUEE) {BEHAVIOR= DIRECTION= LOOP=}

# MULTICOL
set htmlElemAttrRequired1(MULTICOL)	{COLS=}
set htmlElemAttrOptional1(MULTICOL)	{GUTTER= WIDTH=}
set htmlElemAttrNumber1(MULTICOL)	{COLS=2:i:n GUTTER=0:i:n WIDTH=1:i:%}
ensureset htmlElemAttrUsed(MULTICOL) {COLS= GUTTER= WIDTH=}

# NOBR
set htmlElemAttrOptional1(NOBR) {}

# NOEMBED
set htmlElemAttrOptional1(NOEMBED) {}

# NOLAYER
set htmlElemAttrOptional1(NOLAYER) {}

# SERVER
set htmlElemAttrOptional1(SERVER) {}

# SPACER
set htmlElemAttrRequired1(SPACER)	{TYPE=}
set htmlElemAttrOptional1(SPACER)	{SIZE= WIDTH= HEIGHT= ALIGN=}
set htmlElemAttrNumber1(SPACER)	{SIZE=1:i:n WIDTH=1:i:% HEIGHT=1:i:%}
set htmlElemAttrChoices1(SPACER) {TYPE=HORIZONTAL TYPE=VERTICAL TYPE=BLOCK ALIGN=TOP 
ALIGN=MIDDLE ALIGN=BOTTOM ALIGN=LEFT ALIGN=RIGHT}
ensureset htmlElemAttrUsed(SPACER) {TYPE= SIZE= WIDTH= HEIGHT= ALIGN=}

# WBR
set htmlElemAttrOptional1(WBR) 	{}


# Add attrs CLASS, ID, STYLE, TITLE.
# All except {BASE BASEFONT HEAD HTML
# META PARAM SCRIPT STYLE TITLE WBR BGSOUND KEYGEN SERVER}
foreach tmp {TABLE LABEL NOBR SMALL BLOCKQUOTE A TBODY SUB SPAN B TFOOT FORM IFRAME TR 
COL LIVEVIDEO {INPUT TYPE=FILE} TT DFN UL I {INPUT TYPE=SUBMIT} LAYER TEXTAREA LINK 
BLINK SUP P OPTGROUP FIELDSET MULTICOL VAR Q KBD ACRONYM CENTER NOEMBED OL FRAME ISINDEX 
U BDO IMG APPLET LEGEND OPTION HR {INPUT TYPE=TEXT} CITE REALAUDIO ABBR FRAMESET 
SELECT NOLAYER LIVEAUDIO STRIKE {INPUT TYPE=IMAGE} BR BUTTON STRONG SPACER OBJECT DIR FONT 
DD NOSCRIPT INS {INPUT TYPE=PASSWORD} {INPUT TYPE=HIDDEN} COLGROUP DIV MENU {INPUT TYPE=RADIO} 
ADDRESS BODY CAPTION DL SAMP {INPUT TYPE=RESET} CODE {QUICKTIME MOVIE} S {LI IN UL} MAP PRE 
MARQUEE TD DT AREA H1 BIG EM H2 NOFRAMES {INPUT TYPE=BUTTON} H3 {QUICKTIME VR} TH H4 EMBED 
DEL H5 ILAYER THEAD H6 {INPUT TYPE=CHECKBOX} {LI IN OL}} {
	lappend htmlElemAttrOptional1($tmp) CLASS= ID= STYLE= TITLE=
}

# Add attrs LANG, DIR.
# All except {APPLET BASE BASEFONT BDO BR FRAME FRAMESET IFRAME
# PARAM SCRIPT WBR BGSOUND KEYGEN SERVER}
foreach tmp {TABLE LABEL NOBR STYLE SMALL BLOCKQUOTE A TBODY SUB SPAN B TFOOT FORM TR COL HR 
LIVEVIDEO {INPUT TYPE=FILE} TT DFN UL I {INPUT TYPE=SUBMIT} LAYER TEXTAREA LINK META BLINK 
SUP P OPTGROUP FIELDSET MULTICOL VAR Q KBD ACRONYM CENTER NOEMBED OL ISINDEX U IMG LEGEND 
OPTION {INPUT TYPE=TEXT} CITE HTML REALAUDIO ABBR SELECT NOLAYER LIVEAUDIO STRIKE 
{INPUT TYPE=IMAGE} BUTTON STRONG SPACER OBJECT DIR FONT DD NOSCRIPT INS {INPUT TYPE=PASSWORD} 
HEAD {INPUT TYPE=HIDDEN} COLGROUP DIV MENU {INPUT TYPE=RADIO} ADDRESS BODY CAPTION DL SAMP 
{INPUT TYPE=RESET} CODE {QUICKTIME MOVIE} S {LI IN UL} MAP PRE MARQUEE TD DT AREA H1 TITLE 
BIG EM H2 NOFRAMES {INPUT TYPE=BUTTON} H3 {QUICKTIME VR} TH H4 EMBED DEL H5 ILAYER THEAD H6 
{INPUT TYPE=CHECKBOX} {LI IN OL}} {
	lappend htmlElemAttrOptional1($tmp) LANG= DIR=
	lappend htmlElemAttrChoices1($tmp) DIR=LTR DIR=RTL
}

# Add event handlers
# All except {APPLET BASE BASEFONT BDO BR FONT FRAME FRAMESET HEAD HTML
# IFRAME ISINDEX META PARAM SCRIPT STYLE TITLE WBR BGSOUND KEYGEN SERVER}
foreach tmp {TABLE LABEL NOBR SMALL BLOCKQUOTE A TBODY SUB SPAN B TFOOT FORM TR COL 
LIVEVIDEO {INPUT TYPE=FILE} TT DFN UL I {INPUT TYPE=SUBMIT} LAYER TEXTAREA LINK BLINK 
SUP P OPTGROUP FIELDSET MULTICOL VAR Q KBD ACRONYM CENTER NOEMBED OL U IMG LEGEND OPTION 
HR {INPUT TYPE=TEXT} CITE REALAUDIO ABBR SELECT NOLAYER LIVEAUDIO STRIKE 
{INPUT TYPE=IMAGE} BUTTON STRONG SPACER OBJECT DIR DD NOSCRIPT INS {INPUT TYPE=PASSWORD} 
{INPUT TYPE=HIDDEN} COLGROUP DIV MENU {INPUT TYPE=RADIO} ADDRESS BODY CAPTION DL SAMP 
{INPUT TYPE=RESET} CODE {QUICKTIME MOVIE} S {LI IN UL} MAP PRE MARQUEE TD DT AREA H1 
BIG EM H2 NOFRAMES {INPUT TYPE=BUTTON} H3 {QUICKTIME VR} TH H4 EMBED DEL H5 ILAYER THEAD 
H6 {INPUT TYPE=CHECKBOX} {LI IN OL}} {
	lappend htmlElemEventHandler1($tmp) onClick= onDblClick= onMouseDown= onMouseUp= onMouseOver= \
	  onMouseMove= onMouseOut= onKeyPress= onKeyDown= onKeyUp=
}

unset tmp

proc htmlCheckConfig {} {
	
	upvar mayContain mayContain empty empty closingOptional closingOptional
	
	set headmisc {SCRIPT STYLE META LINK OBJECT}
	set headContent {TITLE ISINDEX BASE}
	set heading {H1 H2 H3 H4 H5 H6}
	set lists {UL OL DIR MENU}
	set preformatted {PRE}
	set fontstyle {TT I B U S STRIKE BIG SMALL}
	set phrase {EM STRONG DFN CODE SAMP KBD VAR CITE ABBR ACRONYM}
	set special {A IMG APPLET OBJECT FONT BASEFONT BR SCRIPT MAP Q SUB SUP SPAN BDO IFRAME}
	set formctrl {INPUT SELECT TEXTAREA LABEL BUTTON}
	set inline [concat text $fontstyle $phrase $special $formctrl]
	set block [concat P $heading $lists $preformatted DL DIV CENTER NOSCRIPT NOFRAMES BLOCKQUOTE FORM ISINDEX HR TABLE FIELDSET ADDRESS]
	set flow [concat $inline $block]
	
	# Empty elements
	set empty {BASEFONT BR AREA LINK IMG PARAM HR INPUT COL FRAME ISINDEX BASE META}
	
	# Define what each element mayContain contain
	foreach i [concat $fontstyle $phrase $heading SUB SUP SPAN BDO FONT A P PRE Q DT LABEL LEGEND CAPTION] {
		set mayContain($i) $inline
	}
	foreach i {DIV CENTER BLOCKQUOTE INS DEL DD LI FORM BUTTON TH TD IFRAME NOSCRIPT} {
		set mayContain($i) $flow
	}
	
	set mayContain(A) [lreplace $mayContain(A) [set where [lsearch -exact $mayContain(A) A]] $where]
	set mayContain(FORM) [lreplace $mayContain(FORM) [set where [lsearch -exact $mayContain(FORM) FORM]] $where]
	set mayContain(LABEL) [lreplace $mayContain(LABEL) [set where [lsearch -exact $mayContain(LABEL) LABEL]] $where]
	
	regsub -all {IMG|OBJECT|APPLET|BIG|SMALL|SUB|SUP|FONT|BASEFONT} $mayContain(PRE) "" mayContain(PRE)
	regsub -all "[join $formctrl |]|FORM|ISINDEX|FIELDSET|IFRAME" " $mayContain(BUTTON)" " " mayContain(BUTTON)
	set mayContain(BUTTON) [lreplace $mayContain(BUTTON) [set where [lsearch -exact $mayContain(BUTTON) A]] $where]
	
	foreach i $lists {
		set mayContain($i) LI
	}
	set mayContain(BODY) [concat $flow INS DEL]
	set mayContain(ADDRESS) [concat $inline P]
	set mayContain(MAP) [concat $block AREA]
	set mayContain(OBJECT) [concat $flow PARAM]
	set mayContain(APPLET) [concat $flow PARAM]
	set mayContain(DL) {DT DD}
	set mayContain(SELECT) {OPTGROUP OPTION}
	set mayContain(OPTGROUP) OPTION
	set mayContain(OPTION) text
	set mayContain(TEXTAREA) text
	set mayContain(FIELDSET) [concat $flow LEGEND]
	set mayContain(TABLE) {CAPTION COL COLGROUP THEAD TBODY TFOOT}
	set mayContain(TBODY) TR
	set mayContain(THEAD) TR
	set mayContain(TFOOT) TR
	set mayContain(COLGROUP) COL
	set mayContain(TR) {TD TH}
	set mayContain(FRAMESET) {FRAMESET FRAME NOFRAMES}
	set mayContain(NOFRAMES) [concat BODY $flow]
	set mayContain(NOFRAMES) [lreplace $mayContain(NOFRAMES) [set where [lsearch -exact $mayContain(NOFRAMES) NOFRAMES]] $where]
	set mayContain(HEAD) [concat $headContent $headmisc]
	set mayContain(TITLE) text
	set mayContain(STYLE) text
	set mayContain(SCRIPT) text
	set mayContain(HTML) {HEAD FRAMESET BODY}

	# Dummy tag to start with.
	set mayContain(WINDOW) HTML
	
	# These have an optional closing tag.
	set closingOptional {P DT DD LI OPTION THEAD TBODY TFOOT COLGROUP TR TD TH HEAD BODY HTML WINDOW}
}
